
IF   EXISTS
(
    SELECT *
    FROM SYS.INDEXES
    WHERE NAME = 'UK_PDV_VD_PDV_VD_NFCE_EMP_FILIAL_VD'
          AND OBJECT_ID = OBJECT_ID('PDV_VD_PDV_VD_NFCE')
)
    BEGIN
	   DROP INDEX UK_PDV_VD_PDV_VD_NFCE_EMP_FILIAL_VD ON PDV_VD_PDV_VD_NFCE
    END 
GO
        WITH TABELA
             AS (SELECT ROW_NUMBER() OVER(PARTITION BY CD_EMP,
                                                       CD_FILIAL,
                                                       CD_VD ORDER BY CD_EMP,
                                                                      CD_FILIAL,
                                                                      CD_VD) RN,
                        CD_EMP,
                        CD_FILIAL,
                        CD_VD
                 FROM PDV_VD_PDV_VD_NFCE)
             DELETE FROM TABELA
             WHERE RN > 1;
        CREATE UNIQUE INDEX UK_PDV_VD_PDV_VD_NFCE_EMP_FILIAL_VD ON PDV_VD_PDV_VD_NFCE(CD_EMP, CD_FILIAL, CD_VD);
 
 